package templates

import scala.xml.Node

class EquityForwardTemplate(source: Node) extends TradeTemplate(source) {
  protected[this] def templateTradeBody: Node = {
    <fpml:equityForward>
      <fpml:productType>{ get(source \\ "trade" \ "equityForward" \ "productType") }</fpml:productType>
      <fpml:productId productIdScheme={ get(source \\ "trade" \ "equityForward" \ "productId", "productIdScheme") }>{ get(source \\ "trade" \ "equityForward" \ "productId") }</fpml:productId>
      { /* Uses dictionary from PartyTemplate for identifier */ }
      <fpml:buyerPartyReference href={ parties(get(source \\ "trade" \ "equityForward" \ "buyerPartyReference", "href").mkString)._1 }/>
      <fpml:sellerPartyReference href={ parties(get(source \\ "trade" \ "equityForward" \ "sellerPartyReference", "href").mkString)._1 }/>
      <fpml:optionType>{ "Forward" }</fpml:optionType>
      <fpml:underlyer>
        <fpml:basket>
          <fpml:openUnits>{ get(source \\ "trade" \ "equityForward" \ "underlyer" \\ "basket" \ "openUnits") }</fpml:openUnits>
          { for (s <- source \\ "trade" \ "equityForward" \ "underlyer" \\ "basket" \ "basketConstituent") yield {
              <fpml:basketConstituent>
                <fpml:equity id={ get(s \ "equity", "id") }>
                  <fpml:instrumentId instrumentIdScheme={ get(s \\ "instrumentId", "instrumentIdScheme") }>{ get(s \\ "instrumentId") }</fpml:instrumentId>
                </fpml:equity>
                <fpml:constituentWeight>
                  <fpml:openUnits>{ get(s \\ "openUnits") }</fpml:openUnits>
                  <fpml:basketPercentage>{ get(s \\ "basketPercentage") }</fpml:basketPercentage>
                  <fpml:basketAmount>
                    <fpml:currency>{ get(s \\ "currency") }</fpml:currency>
                    <fpml:amount>{ get(s \\ "amount") }</fpml:amount>
                  </fpml:basketAmount>
                </fpml:constituentWeight>
              </fpml:basketConstituent>
            }
          }
        </fpml:basket>
      </fpml:underlyer>
      <fpml:equityExercise>
        <fpml:equityAmericanExercise>
          <fpml:commencementDate>
            <fpml:adjustableDate>
              <fpml:unadjustedDate>{ get(source \\ "trade" \ "equityForward" \\ "equityAmericanExercise" \ "commencementDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:adjustableDate>
          </fpml:commencementDate>
          <fpml:expirationDate>
            <fpml:adjustableDate>
              <fpml:unadjustedDate>{ get(source \\ "trade" \ "equityForward" \\ "equityAmericanExercise" \ "expirationDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:adjustableDate>
          </fpml:expirationDate>
        </fpml:equityAmericanExercise>
        <fpml:equityBermudaExercise>
          <fpml:bermudaExerciseDates>
            <fpml:adjustableDates>
              <fpml:unadjustedDate>{ get(source \\ "trade" \ "equityForward" \\ "equityBermudaExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:adjustableDates>
          </fpml:bermudaExerciseDates>
        </fpml:equityBermudaExercise>
        <fpml:equityEuropeanExercise>
          <fpml:expirationDate>
            <fpml:adjustableDate>
              <fpml:unadjustedDate>{ get(source \\ "trade" \ "equityForward" \\ "equityEuropeanExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:adjustableDate>
          </fpml:expirationDate>
        </fpml:equityEuropeanExercise>
        <fpml:settlementCurrency>{ get(source \\ "trade" \ "equityForward" \ "equityExercise" \ "settlementCurrency") }</fpml:settlementCurrency>
        <fpml:settlementType>{ get(source \\ "trade" \ "equityForward" \ "equityExercise" \ "settlementType") }</fpml:settlementType>
      </fpml:equityExercise>
      <fpml:forwardPrice>
        <fpml:currency>{ get(source \\ "trade" \ "equityForward" \ "forwardPrice" \ "currency") }</fpml:currency>
        <fpml:amount>{ get(source \\ "trade" \ "equityForward" \ "forwardPrice" \ "amount") }</fpml:amount>
      </fpml:forwardPrice>
    </fpml:equityForward>
  }

  def isStraight = true
}
