package templates

import scala.xml.Node

class EquityOptionTemplate(source: Node) extends TradeTemplate(source) {
  protected[this] def templateTradeBody: Node = {
    <fpml:equityOption>
      <fpml:productType>{ get(source \\ "trade" \ "equityOption" \ "productType") }</fpml:productType>
      <fpml:productId productIdScheme={ get(source \\ "trade" \ "equityOption" \ "productId", "productIdScheme") }>{ get(source \\ "trade" \ "equityOption" \ "productId") }</fpml:productId>
      { /* Uses dictionary from PartyTemplate for identifier */ }
      <fpml:buyerPartyReference href={ parties(get(source \\ "trade" \ "equityOption" \ "buyerPartyReference", "href").mkString)._1 }/>
      <fpml:sellerPartyReference href={ parties(get(source \\ "trade" \ "equityOption" \ "sellerPartyReference", "href").mkString)._1 }/>
      <fpml:optionType>{ get(source \\ "trade" \ "equityOption" \ "optionType") }</fpml:optionType>
      <fpml:underlyer>
        <fpml:singleUnderlyer>
          <fpml:equity id={ get(source \\ "trade" \ "equityOption" \ "underlyer" \ "singleUnderlyer" \ "equity", "id") }>
            <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "equityOption" \ "underlyer" \ "singleUnderlyer" \ "equity" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "equityOption" \ "underlyer" \ "singleUnderlyer" \ "equity" \ "instrumentId") }</fpml:instrumentId>
          </fpml:equity>
          <fpml:bond id={ get(source \\ "trade" \ "equityOption" \ "underlyer" \ "singleUnderlyer" \ "bond", "id") }>
            <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "equityOption" \ "underlyer" \ "singleUnderlyer" \ "bond" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "equityOption" \ "underlyer" \ "singleUnderlyer" \ "bond" \ "instrumentId") }</fpml:instrumentId>
          </fpml:bond>
          <fpml:index id={ get(source \\ "trade" \ "equityOption" \ "underlyer" \ "singleUnderlyer" \ "index", "id") }>
            <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "equityOption" \ "underlyer" \ "singleUnderlyer" \ "index" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "equityOption" \ "underlyer" \ "singleUnderlyer" \ "index" \ "instrumentId") }</fpml:instrumentId>
          </fpml:index>
          <fpml:openUnits>{ get(source \\ "trade" \ "equityOption" \ "underlyer" \ "singleUnderlyer" \ "openUnits") }</fpml:openUnits>
        </fpml:singleUnderlyer>
      </fpml:underlyer>
      <fpml:equityExercise>
        <fpml:equityAmericanExercise>
          <fpml:commencementDate>
            <fpml:adjustableDate>
              <fpml:unadjustedDate>{ get(source \\ "trade" \ "equityOption" \\ "equityAmericanExercise" \ "commencementDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:adjustableDate>
          </fpml:commencementDate>
          <fpml:expirationDate>
            <fpml:adjustableDate>
              <fpml:unadjustedDate>{ get(source \\ "trade" \ "equityOption" \\ "equityAmericanExercise" \ "expirationDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:adjustableDate>
          </fpml:expirationDate>
        </fpml:equityAmericanExercise>
        <fpml:equityBermudaExercise>
          <fpml:bermudaExerciseDates>
            <fpml:adjustableDates>
              <fpml:unadjustedDate>{ get(source \\ "trade" \ "equityOption" \\ "equityBermudaExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:adjustableDates>
          </fpml:bermudaExerciseDates>
        </fpml:equityBermudaExercise>
        <fpml:equityEuropeanExercise>
          <fpml:expirationDate>
            <fpml:adjustableDate>
              <fpml:unadjustedDate>{ get(source \\ "trade" \ "equityOption" \\ "equityEuropeanExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:adjustableDate>
          </fpml:expirationDate>
        </fpml:equityEuropeanExercise>
        <fpml:settlementCurrency>{ get(source \\ "trade" \ "equityOption" \ "equityExercise" \ "settlementCurrency") }</fpml:settlementCurrency>
        <fpml:settlementType>{ get(source \\ "trade" \ "equityOption" \ "equityExercise" \ "settlementType") }</fpml:settlementType>
      </fpml:equityExercise>
      <fpml:strike>
        <fpml:strikePrice>{ get(source \\ "trade" \ "equityOption" \ "strike" \\ "strikePrice") }</fpml:strikePrice>
        <fpml:strikePercentage>{ get(source \\ "trade" \ "equityOption" \ "strike" \\ "strikePercentage") }</fpml:strikePercentage>
        <fpml:currency>{ get(source \\ "trade" \ "equityOption" \ "strike" \ "currency") }</fpml:currency>
      </fpml:strike>
      <fpml:numberOfOptions>{ get(source \\ "trade" \ "equityOption" \ "numberOfOptions") }</fpml:numberOfOptions>
      <fpml:optionEntitlement>{ get(source \\ "trade" \ "equityOption" \ "optionEntitlement") }</fpml:optionEntitlement>
      <fpml:equityPremium>
        { /* Uses dictionary from PartyTemplate for identifier */ }
        <fpml:payerPartyReference href={ parties(get(source \\ "trade" \ "equityOption" \ "equityPremium" \"payerPartyReference", "href").mkString)._1 }/>
        <fpml:receiverPartyReference href={ parties(get(source \\ "trade" \ "equityOption" \ "equityPremium" \"receiverPartyReference", "href").mkString)._1 }/>
        <fpml:paymentAmount>
          <fpml:currency>{ get(source \\ "trade" \ "equityOption" \ "equityPremium" \\ "currency") }</fpml:currency>
          <fpml:amount>{ get(source \\ "trade" \ "equityOption" \ "equityPremium" \\ "amount") }</fpml:amount>
        </fpml:paymentAmount>
      </fpml:equityPremium>
    </fpml:equityOption>
  }

  def isStraight = true
}
