package templates

import scala.xml.Node

class ExecutionStatusReportTemplate(source: Node) extends PartyTemplate(source) {

  def template: Node = {
    <rtsrep:executionStatusReportRegistration xmlns:fpml="http://www.fpml.org/FpML-5/recordkeeping"
                                        xmlns:fpmlext="http://www.fpml.org/FpML-5/ext" xmlns:rtsrep="http://www.fpml.ru/repository"
                                        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" fpmlVersion="5-7">
      <fpml:header>
        <fpml:messageId>{ get(source \ "header" \"messageId") }</fpml:messageId>
        <fpml:sentBy>{ get(source \ "header" \ "sentBy") }</fpml:sentBy>
        <fpml:sendTo>{ get(source \ "header" \ "sendTo") }</fpml:sendTo>
        <fpml:creationTimestamp>{ get(source \ "header" \ "creationTimestamp") }</fpml:creationTimestamp>
        <fpml:implementationSpecification>
          <fpml:version>2</fpml:version>
        </fpml:implementationSpecification>
      </fpml:header>
      <fpml:isCorrection>{ get(source \ "isCorrection") }</fpml:isCorrection>
      <fpml:correlationId correlationIdScheme="">{ get(source \ "correlationId") }</fpml:correlationId>
      <rtsrep:tradeId>{ get(source \ "executionStatus" \ "tradesWithStatus" \\ "tradeId") }</rtsrep:tradeId>
      {/* statusDate isn`t present in the source */}
      <rtsrep:statusDate>{ get(source \ "asOfDate") }</rtsrep:statusDate>
      <rtsrep:tradeObligationStatus>{ get(source \ "executionStatus" \ "tradesWithStatus" \ "tradeObligationStatus") }</rtsrep:tradeObligationStatus>
    </rtsrep:executionStatusReportRegistration>
  }

  def isStraight = true
}
