package templates
import scala.xml.{Node, NodeSeq}

class MasterAgreementTemplate(source: Node) extends RegiAmendTermMasterAgreementTemplate(source) {
  protected[this] def templateMATerms: NodeSeq = {

    val utip =
      (source \\ "trade" \ "tradeHeader" \ "partyTradeIdentifier")
        .filter(_.child.filter(_.attributes.nonEmpty).head.attributes("href").text.mkString == "UTIGeneratingParty")
    val rp =
      (source \\ "trade" \ "tradeHeader" \ "partyTradeIdentifier")
        .filter(_.child.filter(_.attributes.nonEmpty).head.attributes("href").text.mkString == "Party1")
    val nrp =
      (source \\ "trade" \ "tradeHeader" \ "partyTradeIdentifier")
        .filter(_.child.filter(_.attributes.nonEmpty).head.attributes("href").text.mkString == "Party2")

    <rtsrep:masterAgreement>
      {/* masterAgreementId isn`t present in the source */}
      <rtsrep:masterAgreementId>{ "NONREF" }</rtsrep:masterAgreementId>
      <rtsrep:masterAgreementType>{ get(source \\ "trade" \ "masterAgreementTerms" \ "masterAgreementType") }</rtsrep:masterAgreementType>
      <rtsrep:masterAgreementVersion>{ get(source \\ "trade" \ "masterAgreementTerms" \ "masterAgreementVersion") }</rtsrep:masterAgreementVersion>
      {/* masterAgreementDate isn`t present in the source */}
      <rtsrep:masterAgreementDate>{ get(source \\ "trade" \ "tradeHeader" \ "tradeDate") }</rtsrep:masterAgreementDate>
    </rtsrep:masterAgreement>
    <rtsrep:masterAgreementParty>
      { /* Uses dictionary from PartyTemplate for identifier */ }
      <rtsrep:masterAgreementPartyReference href={ parties(get(rp \ "partyReference", "href").mkString)._1 }/>
      <rtsrep:masterAgreementId>{ get(utip \ "tradeId") }</rtsrep:masterAgreementId>
      <rtsrep:reportingParty>
        { /* Uses dictionary from PartyTemplate for identifier */ }
        <rtsrep:reportingPartyReference href={ parties(get(rp \ "partyReference", "href").mkString)._1 }/>
        {/* productType isn`t present in the source */}
        <rtsrep:productType>{ "All" }</rtsrep:productType>
      </rtsrep:reportingParty>
    </rtsrep:masterAgreementParty>
    <rtsrep:nonreportingParty>
      { /* Uses dictionary from PartyTemplate for identifier */ }
      <rtsrep:partyReference href={ parties(get(nrp \ "partyReference", "href").mkString)._1 }/>
    </rtsrep:nonreportingParty>
    <rtsrep:partyRelatedType>{ get(source \\ "trade" \ "masterAgreementTerms" \ "partiesAreAffiliated") }</rtsrep:partyRelatedType>
    <rtsrep:attachment>
      <fpml:name></fpml:name>
    </rtsrep:attachment>
  }

  def isStraight = true
}
