package templates

import scala.xml.{Node, NodeSeq}

abstract class RegiAmendTermMasterAgreementTemplate(source: Node) extends PartyTemplate(source) {
  protected[this] def templateMATerms: NodeSeq

  def template: Node = {
    <rtsrep:masterAgreementRegistration xmlns:fpml="http://www.fpml.org/FpML-5/recordkeeping"
                                        xmlns:fpmlext="http://www.fpml.org/FpML-5/ext" xmlns:rtsrep="http://www.fpml.ru/repository"
                                        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" fpmlVersion="5-7">
      <fpml:header>
        <fpml:messageId>{ get(source \ "header" \"messageId") }</fpml:messageId>
        <fpml:sentBy>{ get(source \ "header" \ "sentBy") }</fpml:sentBy>
        <fpml:sendTo>{ get(source \ "header" \ "sendTo") }</fpml:sendTo>
        <fpml:creationTimestamp>{ get(source \ "header" \ "creationTimestamp") }</fpml:creationTimestamp>
        <fpml:implementationSpecification>
          <fpml:version>2</fpml:version>
        </fpml:implementationSpecification>
      </fpml:header>
      <fpml:isCorrection>{ get(source \ "isCorrection") }</fpml:isCorrection>
      <fpml:correlationId correlationIdScheme="">{ get(source \ "correlationId") }</fpml:correlationId>
      { if ((source \ "masterAgreementTermination").nonEmpty)
          <rtsrep:terminationMasterAgreement>
            <rtsrep:masterAgreementId>{ get(source \ "masterAgreementTermination" \ "masterAgreementId") }</rtsrep:masterAgreementId>
            <rtsrep:terminationDate>{ get(source \ "masterAgreementTermination" \ "terminationDate") }</rtsrep:terminationDate>
            <rtsrep:reason>{ get(source \ "masterAgreementTermination" \ "maTerminatingReason") }</rtsrep:reason>
          </rtsrep:terminationMasterAgreement>
        else if ((source \ "amendment").isEmpty)
          <rtsrep:registrationMasterAgreement>
            { templateMATerms }
          </rtsrep:registrationMasterAgreement>
        else
          <rtsrep:amendmentMasterAgreement>
            { templateMATerms }
            <fpml:agreementDate>{ get(source \ "amendment" \ "agreementDate") }</fpml:agreementDate>
            <fpml:effectiveDate>{ get(source \ "amendment" \ "effectiveDate") }</fpml:effectiveDate>
          </rtsrep:amendmentMasterAgreement>
      }
      { /* Uses dictionary from PartyTemplate for identifier */ }
      { for { s <- source \ "party"
              id = get(s, "id").mkString
              if id != "Sender" && id != "UTIGeneratingParty" } yield {
          <fpml:party id={ parties(id)._1 }>
            <fpml:partyId partyIdScheme={ parties(id)._2 }>{ parties(id)._1 }</fpml:partyId>
            <fpml:partyName>{ get(s \ "partyName") }</fpml:partyName>
            <fpml:country>{ get(s \ "country") }</fpml:country>
            <fpml:organizationType>{ get(s \ "classification") }</fpml:organizationType>
          </fpml:party>
        }
      }
    </rtsrep:masterAgreementRegistration>
  }
}
