package templates

import scala.xml.Node

class RepoTemplate(source: Node) extends TradeTemplate(source) {
  protected[this] def templateTradeBody: Node = {
    <fpmlext:repo xsi:type="rtsrep:Repo">
      <fpml:productId>{ get(source \\ "trade" \ "repo" \ "productType") }</fpml:productId>
      <fpml:productId productIdScheme={ get(source \\ "trade" \ "repo" \ "productId", "productIdScheme") }>{ get(source \\ "trade" \ "repo" \ "productId") }</fpml:productId>
      <fpmlext:fixedRateSchedule>
        <fpml:initialValue>{ get(source \\ "trade" \ "repo" \ "fixedRateSchedule" \ "initialValue") }</fpml:initialValue>
        <fpml:step>
          <fpml:stepDate>{ get(source \\ "trade" \ "repo" \ "fixedRateSchedule" \\ "stepDate") }</fpml:stepDate>
          <fpml:stepValue>{ get(source \\ "trade" \ "repo" \ "fixedRateSchedule" \\ "stepValue") }</fpml:stepValue>
        </fpml:step>
      </fpmlext:fixedRateSchedule>
      <fpmlext:floatingRateCalculation>
        <fpml:floatingRateIndex>{ get(source \\ "trade" \ "repo" \ "floatingRateCalculation" \ "floatingRateIndex") }</fpml:floatingRateIndex>
        <fpml:indexTenor>
          <fpml:periodMultiplier>{ get(source \\ "trade" \ "repo" \ "floatingRateCalculation" \\ "periodMultiplier") }</fpml:periodMultiplier>
          <fpml:period>{ get(source \\ "trade" \ "repo" \ "floatingRateCalculation" \\ "period") }</fpml:period>
        </fpml:indexTenor>
        <fpml:spreadSchedule>
          <fpml:initialValue>{ get(source \\ "trade" \ "repo" \ "floatingRateCalculation" \\ "initialValue") }</fpml:initialValue>
        </fpml:spreadSchedule>
        <fpml:initialRate>{ get(source \\ "trade" \ "repo" \ "floatingRateCalculation" \\ "initialRate") }</fpml:initialRate>
      </fpmlext:floatingRateCalculation>
      <fpmlext:dayCountFraction>{ get(source \\ "trade" \ "repo" \ "dayCountFraction") }</fpmlext:dayCountFraction>
      <fpmlext:spotLeg xsi:type="rtsrep:RepoTransactionLeg">
        { /* Uses dictionary from PartyTemplate for identifier */ }
        <fpml:buyerPartyReference href={ parties(get(source \\ "trade" \ "repo" \ "spotLeg" \ "buyerPartyReference", "href").mkString)._1 } />
        <fpml:sellerPartyReference href={ parties(get(source \\ "trade" \ "repo" \ "spotLeg" \ "sellerPartyReference", "href").mkString)._1 } />
        <fpmlext:settlementDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "repo" \ "spotLeg" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </fpmlext:settlementDate>
        <fpml:settlementAmount>
          <fpml:currency>{ get(source \\ "trade" \ "repo" \ "spotLeg" \\ "currency") }</fpml:currency>
          <fpml:amount>{ get(source \\ "trade" \ "repo" \ "spotLeg" \\ "amount") }</fpml:amount>
        </fpml:settlementAmount>
        <fpmlext:collateral>
          <fpmlext:numberOfUnits>{ get(source \\ "trade" \ "repo" \ "spotLeg" \ "collateral" \ "numberOfUnits") }</fpmlext:numberOfUnits>
          <fpmlext:unitPrice>
            <fpml:currency>{ get(source \\ "trade" \ "repo" \ "spotLeg" \ "collateral" \ "unitPrice" \ "currency") }</fpml:currency>
            <fpml:amount>{ get(source \\ "trade" \ "repo" \ "spotLeg" \ "collateral" \ "unitPrice" \ "amount") }</fpml:amount>
          </fpmlext:unitPrice>
          <fpmlext:nominalAmount>
            <fpml:currency>{ get(source \\ "trade" \ "repo" \ "spotLeg" \ "collateral" \ "nominalAmount" \ "currency") }</fpml:currency>
            <fpml:amount>{ get(source \\ "trade" \ "repo" \ "spotLeg" \ "collateral" \ "nominalAmount" \ "amount") }</fpml:amount>
          </fpmlext:nominalAmount>
          <fpmlext:assetReference href={ get(source \\ "trade" \ "repo" \ "spotLeg" \ "collateral" \ "assetReference", "href") }/>
        </fpmlext:collateral>
        <rtsrep:deliveryDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "repo" \ "spotLeg" \ "deliveryDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </rtsrep:deliveryDate>
      </fpmlext:spotLeg>
      <fpmlext:forwardLeg xsi:type="rtsrep:ForwardRepoTransactionLeg">
        { /* Uses dictionary from PartyTemplate for identifier */ }
        <fpml:buyerPartyReference href={ parties(get(source \\ "trade" \ "repo" \ "forwardLeg" \ "buyerPartyReference", "href").mkString)._1 } />
        <fpml:sellerPartyReference href={ parties(get(source \\ "trade" \ "repo" \ "forwardLeg" \ "sellerPartyReference", "href").mkString)._1 } />
        <fpmlext:settlementDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "repo" \ "forwardLeg" \ "settlementDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </fpmlext:settlementDate>
        <fpml:settlementAmount>
          <fpml:currency>{ get(source \\ "trade" \ "repo" \ "forwardLeg" \\ "currency") }</fpml:currency>
          <fpml:amount>{ get(source \\ "trade" \ "repo" \ "forwardLeg" \\ "amount") }</fpml:amount>
        </fpml:settlementAmount>
        <rtsrep:deliveryDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "repo" \ "forwardLeg" \ "deliveryDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </rtsrep:deliveryDate>
      </fpmlext:forwardLeg>
      <fpml:equity id={ get(source \\ "trade" \ "repo" \ "equity", "id") }>
        <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "repo" \ "equity" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "repo" \ "equity" \ "instrumentId") }</fpml:instrumentId>
      </fpml:equity>
      <fpml:bond id={ get(source \\ "trade" \ "repo" \ "bond", "id") }>
        <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "repo" \ "bond" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "repo" \ "bond" \ "instrumentId") }</fpml:instrumentId>
      </fpml:bond>
    </fpmlext:repo>
  }

  def isStraight = true
}