package xmlvalid

import org.scalatest._

import scala.xml.{Node, SAXParser}

class XMLValidSpec extends WordSpec {

  "XMLValid" can {
    "envoke parser:SAXParser if schema is valid" in {
      val validXml = XMLValid(getClass.getResource("/xmlvalid/test_valid.xsd"))
      assert(validXml.parser.isInstanceOf[SAXParser])
    }
  }

  it should {
    "successfully loadFile(xmlPath) with well formed and valid xml" in {
      val validXml = XMLValid(getClass.getResource("/xmlvalid/test_valid.xsd"))
      val xml = validXml.load(getClass.getResource("/xmlvalid/test_valid.xml"))
      assert(xml.isInstanceOf[Node])
    }
  }

  it should {
    "throw exception with nonexisting schema" in {
      assertThrows[Exception] {
        val validXml = XMLValid(getClass.getResource("/xmlvalid/test_foo.xsd"))
      }
    }
  }

  it should {
    "throw exception with invalid schema" in {
      assertThrows[Exception] {
        val validXml = XMLValid(getClass.getResource("/xmlvalid/test_invalid.xsd"))
      }
    }
  }

  it should {
    "throw exception in loadFile(xmlPath) with nonexisting xml" in {
      assertThrows[Exception] {
        val validXml = XMLValid(getClass.getResource("/xmlvalid/test_valid.xsd"))
        val xml = validXml.load(getClass.getResource("/xmlvalid/test_foo.xml"))
      }
    }
  }

  it should {
    "throw exception in loadFile(xmlPath) with well formed but invalid xml" in {
      assertThrows[Exception] {
        val validXml = XMLValid(getClass.getResource("/xmlvalid/test.xsd"))
        val xml = validXml.load(getClass.getResource("/xmlvalid/test_invalid.xml"))
      }
    }
  }

  it should {
    "throw exception with error xml" in {
      assertThrows[Exception] {
        val validXml = XMLValid(getClass.getResource("/xmlvalid/test.xsd"))
        val xml = validXml.load(getClass.getResource("/xmlvalid/test_error.xml"))
      }
    }
  }
}
