package templates

import scala.xml.Node

class BondBasketOptionTemplate(source: Node) extends TradeTemplate(source) {
  protected[this] def templateTradeBody: Node = {
    <rtsrep:bondBasketOption>
      <fpml:productType>{ get(source \\ "trade" \ "bondBasketOption" \ "productType") }</fpml:productType>
      <fpml:productId productIdScheme={ get(source \\ "trade" \ "bondBasketOption" \ "productId", "productIdScheme") }>{ get(source \\ "trade" \ "bondBasketOption" \ "productId") }</fpml:productId>
      { /* Uses dictionary from PartyTemplate for identifier */ }
      <fpml:buyerPartyReference href={ parties(get(source \\ "trade" \ "bondBasketOption" \ "buyerPartyReference", "href").mkString)._1 }/>
      <fpml:sellerPartyReference href={ parties(get(source \\ "trade" \ "bondBasketOption" \ "sellerPartyReference", "href").mkString)._1 }/>
      <fpml:optionType>{ get(source \\ "trade" \ "bondBasketOption" \ "optionType") }</fpml:optionType>
      <fpml:premium>
        { /* Uses dictionary from PartyTemplate for identifier */ }
        <fpml:payerPartyReference href={ parties(get(source \\ "trade" \ "bondBasketOption" \ "premium" \"payerPartyReference", "href").mkString)._1 }/>
        <fpml:receiverPartyReference href={ parties(get(source \\ "trade" \ "bondBasketOption" \ "premium" \"receiverPartyReference", "href").mkString)._1 }/>
        <fpml:paymentAmount>
          <fpml:currency>{ get(source \\ "trade" \ "bondBasketOption" \ "premium" \\ "currency") }</fpml:currency>
          <fpml:amount>{ get(source \\ "trade" \ "bondBasketOption" \ "premium" \\ "amount") }</fpml:amount>
        </fpml:paymentAmount>
        { /* paymentDate isn`t present in source!!!*/ }
        <fpml:paymentDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondBasketOption" \ "americanExercise" \ "expirationDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondBasketOption" \ "bermudaExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondBasketOption" \ "europeanExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </fpml:paymentDate>
      </fpml:premium>
      <fpml:americanExercise>
        <fpml:commencementDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondBasketOption" \ "americanExercise" \ "commencementDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </fpml:commencementDate>
        <fpml:expirationDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondBasketOption" \ "americanExercise" \ "expirationDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </fpml:expirationDate>
      </fpml:americanExercise>
      <fpml:bermudaExercise>
        <fpml:bermudaExerciseDates>
          <fpml:adjustableDates>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondBasketOption" \ "bermudaExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDates>
        </fpml:bermudaExerciseDates>
      </fpml:bermudaExercise>
      <fpml:europeanExercise>
        <fpml:expirationDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondBasketOption" \ "europeanExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </fpml:expirationDate>
      </fpml:europeanExercise>
      <fpml:notionalAmount>
        <fpml:currency>{ get(source \\ "trade" \ "bondBasketOption" \ "notionalAmount" \ "currency") }</fpml:currency>
        <fpml:amount>{ get(source \\ "trade" \ "bondBasketOption" \ "notionalAmount" \ "amount") }</fpml:amount>
      </fpml:notionalAmount>
      <fpml:optionEntitlement>{ get(source \\ "trade" \ "bondBasketOption" \ "optionEntitlement") }</fpml:optionEntitlement>
      <fpml:numberOfOptions>{ get(source \\ "trade" \ "bondBasketOption" \ "numberOfOptions") }</fpml:numberOfOptions>
      <fpml:settlementType>{ get(source \\ "trade" \ "bondBasketOption" \ "settlementType") }</fpml:settlementType>
      <rtsrep:strike>
        <fpml:price>
          <fpml:strikePrice>{ get(source \\ "trade" \ "bondBasketOption" \ "strike" \\ "strikePrice") }</fpml:strikePrice>
          <fpml:strikePercentage>{ get(source \\ "trade" \ "bondBasketOption" \ "strike" \\ "strikePercentage") }</fpml:strikePercentage>
          <fpml:currency>{ get(source \\ "trade" \ "bondBasketOption" \ "strike" \\ "currency") }</fpml:currency>
        </fpml:price>
      </rtsrep:strike>
      <fpml:basket>
        <fpml:openUnits>{ get(source \\ "trade" \ "bondBasketOption" \ "basket" \ "openUnits") }</fpml:openUnits>
        { for (s <- source \\ "trade" \ "bondBasketOption" \ "basket" \ "basketConstituent") yield {
            <fpml:basketConstituent>
              <fpml:bond id={ get(s \ "bond", "id") }>
                <fpml:instrumentId instrumentIdScheme={ get(s \\ "instrumentId", "instrumentIdScheme") }>{ get(s \\ "instrumentId") }</fpml:instrumentId>
              </fpml:bond>
              <fpml:constituentWeight>
                <fpml:openUnits>{ get(s \\ "openUnits") }</fpml:openUnits>
                <fpml:basketPercentage>{ get(s \\ "basketPercentage") }</fpml:basketPercentage>
                <fpml:basketAmount>
                  <fpml:currency>{ get(s \\ "currency") }</fpml:currency>
                  <fpml:amount>{ get(s \\ "amount") }</fpml:amount>
                </fpml:basketAmount>
              </fpml:constituentWeight>
            </fpml:basketConstituent>
          }
        }
      </fpml:basket>
    </rtsrep:bondBasketOption>
  }

  def isStraight = true
}
