package templates

import scala.xml.Node

class BondForwardTemplate(source: Node) extends TradeTemplate(source) {
  protected[this] def templateTradeBody: Node = {
    <rtsrep:bondForward>
      <fpml:productType>{ get(source \\ "trade" \ "bondForward" \ "productType") }</fpml:productType>
      <fpml:productId productIdScheme={ get(source \\ "trade" \ "bondForward" \ "productId", "productIdScheme") }>{ get(source \\ "trade" \ "bondForward" \ "productId") }</fpml:productId>
      { /* Uses dictionary from PartyTemplate for identifier */ }
      <fpml:buyerPartyReference href={ parties(get(source \\ "trade" \ "bondForward" \ "buyerPartyReference", "href").mkString)._1 }/>
      <fpml:sellerPartyReference href={ parties(get(source \\ "trade" \ "bondForward" \ "sellerPartyReference", "href").mkString)._1 }/>
      <rtsrep:underlyer>
        <fpml:singleUnderlyer>
          <fpml:equity id={ get(source \\ "trade" \ "bondForward" \ "underlyer" \ "singleUnderlyer" \ "equity", "id") }>
            <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "bondForward" \ "underlyer" \ "singleUnderlyer" \ "equity" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "bondForward" \ "underlyer" \ "singleUnderlyer" \ "equity" \ "instrumentId") }</fpml:instrumentId>
          </fpml:equity>
          <fpml:bond id={ get(source \\ "trade" \ "bondForward" \ "underlyer" \ "singleUnderlyer" \ "bond", "id") }>
            <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "bondForward" \ "underlyer" \ "singleUnderlyer" \ "bond" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "bondForward" \ "underlyer" \ "singleUnderlyer" \ "bond" \ "instrumentId") }</fpml:instrumentId>
          </fpml:bond>
          <fpml:index id={ get(source \\ "trade" \ "bondForward" \ "underlyer" \ "singleUnderlyer" \ "index", "id") }>
            <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "bondForward" \ "underlyer" \ "singleUnderlyer" \ "index" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "bondForward" \ "underlyer" \ "singleUnderlyer" \ "index" \ "instrumentId") }</fpml:instrumentId>
          </fpml:index>
          <fpml:openUnits>{ get(source \\ "trade" \ "bondForward" \ "underlyer" \ "singleUnderlyer" \ "openUnits") }</fpml:openUnits>
        </fpml:singleUnderlyer>
      </rtsrep:underlyer>
      <rtsrep:notionalAmount>
        <fpml:currency>{ get(source \\ "trade" \ "bondForward" \ "notionalAmount" \ "currency") }</fpml:currency>
        <fpml:amount>{ get(source \\ "trade" \ "bondForward" \ "notionalAmount" \ "amount") }</fpml:amount>
      </rtsrep:notionalAmount>
      { /* settlementType isn`t present in source!!!*/ }
      <rtsrep:settlementType>{ "CashOrPhysical" }</rtsrep:settlementType>
      <rtsrep:settlementDate>
        <fpml:adjustableDate>
          <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondForward" \ "settlementDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
        </fpml:adjustableDate>
      </rtsrep:settlementDate>
      <rtsrep:settlementCurrency>{ get(source \\ "trade" \ "bondForward" \ "settlementCurrency") }</rtsrep:settlementCurrency>
      <rtsrep:forwardPrice>
        <rtsrep:forwardPricePerBond>
          <fpml:currency>{ get(source \\ "trade" \ "bondForward" \ "forwardPrice" \\ "currency") }</fpml:currency>
          <fpml:amount>{ get(source \\ "trade" \ "bondForward" \ "forwardPrice" \\ "amount") }</fpml:amount>
        </rtsrep:forwardPricePerBond>
        <rtsrep:forwardPricePercentage>{ get(source \\ "trade" \ "bondForward" \ "forwardPrice" \ "forwardPricePercentage") }</rtsrep:forwardPricePercentage>
      </rtsrep:forwardPrice>
    </rtsrep:bondForward>
  }

  def isStraight = true
}
