package templates

import scala.xml.Node

class BondOptionTemplate(source: Node) extends TradeTemplate(source) {
  protected[this] def templateTradeBody: Node = {
    <fpml:bondOption>
      <fpml:productType>{ get(source \\ "trade" \ "bondOption" \ "productType") }</fpml:productType>
      <fpml:productId productIdScheme={ get(source \\ "trade" \ "bondOption" \ "productId", "productIdScheme") }>{ get(source \\ "trade" \ "bondOption" \ "productId") }</fpml:productId>
      { /* Uses dictionary from PartyTemplate for identifier */ }
      <fpml:buyerPartyReference href={ parties(get(source \\ "trade" \ "bondOption" \ "buyerPartyReference", "href").mkString)._1 }/>
      <fpml:sellerPartyReference href={ parties(get(source \\ "trade" \ "bondOption" \ "sellerPartyReference", "href").mkString)._1 }/>
      <fpml:optionType>{ get(source \\ "trade" \ "bondOption" \ "optionType") }</fpml:optionType>
      <fpml:premium>
        { /* Uses dictionary from PartyTemplate for identifier */ }
        <fpml:payerPartyReference href={ parties(get(source \\ "trade" \ "bondOption" \ "premium" \"payerPartyReference", "href").mkString)._1 }/>
        <fpml:receiverPartyReference href={ parties(get(source \\ "trade" \ "bondOption" \ "premium" \"receiverPartyReference", "href").mkString)._1 }/>
        <fpml:paymentAmount>
          <fpml:currency>{ get(source \\ "trade" \ "bondOption" \ "premium" \\ "currency") }</fpml:currency>
          <fpml:amount>{ get(source \\ "trade" \ "bondOption" \ "premium" \\ "amount") }</fpml:amount>
        </fpml:paymentAmount>
        { /* paymentDate isn`t present in source!!!*/ }
        <fpml:paymentDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondOption" \ "americanExercise" \ "expirationDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondOption" \ "bermudaExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondOption" \ "europeanExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </fpml:paymentDate>
      </fpml:premium>
      <fpml:americanExercise>
        <fpml:commencementDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondOption" \ "americanExercise" \ "commencementDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </fpml:commencementDate>
        <fpml:expirationDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondOption" \ "americanExercise" \ "expirationDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </fpml:expirationDate>
      </fpml:americanExercise>
      <fpml:bermudaExercise>
        <fpml:bermudaExerciseDates>
          <fpml:adjustableDates>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondOption" \ "bermudaExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDates>
        </fpml:bermudaExerciseDates>
      </fpml:bermudaExercise>
      <fpml:europeanExercise>
        <fpml:expirationDate>
          <fpml:adjustableDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "bondOption" \ "europeanExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDate>
        </fpml:expirationDate>
      </fpml:europeanExercise>
      <fpml:notionalAmount>
        <fpml:currency>{ get(source \\ "trade" \ "bondOption" \ "notionalAmount" \ "currency") }</fpml:currency>
        <fpml:amount>{ get(source \\ "trade" \ "bondOption" \ "notionalAmount" \ "amount") }</fpml:amount>
      </fpml:notionalAmount>
      <fpml:optionEntitlement>{ get(source \\ "trade" \ "bondOption" \ "optionEntitlement") }</fpml:optionEntitlement>
      <fpml:numberOfOptions>{ get(source \\ "trade" \ "bondOption" \ "numberOfOptions") }</fpml:numberOfOptions>
      <fpml:settlementType>{ get(source \\ "trade" \ "bondOption" \ "settlementType") }</fpml:settlementType>
      <fpml:strike>
        <fpml:price>
          <fpml:strikePrice>{ get(source \\ "trade" \ "bondOption" \ "strike" \\ "strikePrice") }</fpml:strikePrice>
          <fpml:strikePercentage>{ get(source \\ "trade" \ "bondOption" \ "strike" \\ "strikePercentage") }</fpml:strikePercentage>
          <fpml:currency>{ get(source \\ "trade" \ "bondOption" \ "strike" \\ "currency") }</fpml:currency>
        </fpml:price>
      </fpml:strike>
      <fpml:bond id={ get(source \\ "trade" \ "bondOption" \ "bond", "id") }>
        <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "bondOption" \ "bond" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "bondOption" \ "bond" \ "instrumentId") }</fpml:instrumentId>
      </fpml:bond>
    </fpml:bondOption>
  }

  def isStraight = true
}
