package templates

import scala.xml.Node

class CommodityForwardTemplate(source: Node) extends TradeTemplate(source) {
  protected[this] def templateTradeBody: Node = {
    <fpml:commodityForward>
      <fpml:productType>{ get(source \\ "trade" \ "commodityForward" \ "productType") }</fpml:productType>
      <fpml:productId>{ get(source \\ "trade" \ "commodityForward" \ "productId") }</fpml:productId>
      { /* valueDate isn`t present in source!!!*/  }
      <fpml:valueDate>
        <fpml:adjustableDate>
          <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityForward" \ "fixedLeg" \ "paymentDates" \\ "unadjustedDate") }</fpml:unadjustedDate>
        </fpml:adjustableDate>
      </fpml:valueDate>
      <fpml:fixedLeg>
        { /* Uses dictionary from PartyTemplate for identifier */ }
        <fpml:payerPartyReference href={ parties(get(source \\ "trade" \ "commodityForward" \ "fixedLeg" \ "payerPartyReference", "href").mkString)._1 }/>
        <fpml:receiverPartyReference href={ parties(get(source \\ "trade" \ "commodityForward" \ "fixedLeg" \ "receiverPartyReference", "href").mkString)._1 }/>
        <fpml:fixedPrice>
          <fpml:price>{ get(source \\ "trade" \ "commodityForward" \ "fixedLeg" \ "fixedPrice" \ "price") }</fpml:price>
          <fpml:priceCurrency>{ get(source \\ "trade" \ "commodityForward" \ "fixedLeg" \ "fixedPrice" \ "priceCurrency") }</fpml:priceCurrency>
          <fpml:priceUnit>{ get(source \\ "trade" \ "commodityForward" \ "fixedLeg" \ "fixedPrice" \ "priceUnit") }</fpml:priceUnit>
        </fpml:fixedPrice>
        <fpml:totalPrice>
          <fpml:currency>{ get(source \\ "trade" \ "commodityForward" \ "fixedLeg" \ "totalPrice" \ "currency") }</fpml:currency>
          <fpml:amount>{ get(source \\ "trade" \ "commodityForward" \ "fixedLeg" \ "totalPrice" \ "amount") }</fpml:amount>
        </fpml:totalPrice>
        <fpml:paymentDates>
          <fpml:adjustableDates>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityForward" \ "fixedLeg" \ "paymentDates" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDates>
        </fpml:paymentDates>
      </fpml:fixedLeg>
      <rtsrep:commodityPhysicalLeg>
        { /* Uses dictionary from PartyTemplate for identifier */ }
        <fpml:payerPartyReference href={ parties(get(source \\ "trade" \ "commodityForward" \ "commodityForwardPhysicalLeg" \ "payerPartyReference", "href").mkString)._1 }/>
        <fpml:receiverPartyReference href={ parties(get(source \\ "trade" \ "commodityForward" \ "commodityForwardPhysicalLeg" \ "receiverPartyReference", "href").mkString)._1 }/>
        <rtsrep:commodity id={ get(source \\ "trade" \ "commodityForward" \ "commodityForwardPhysicalLeg" \ "commodity", "id") }>
          <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "commodityForward" \ "commodityForwardPhysicalLeg" \ "commodity" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "commodityForward" \ "commodityForwardPhysicalLeg" \ "commodity" \ "instrumentId") }</fpml:instrumentId>
          <fpml:unit>{ get(source \\ "trade" \ "commodityForward" \ "commodityForwardPhysicalLeg" \ "commodity" \ "unit") }</fpml:unit>
          <fpml:currency>{ get(source \\ "trade" \ "commodityForward" \ "commodityForwardPhysicalLeg" \ "commodity" \ "currency") }</fpml:currency>
          { /* deliveryDate isn`t present in source!!! */ }
          <fpml:deliveryDate>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityForward" \ "commodityForwardPhysicalLeg" \ "deliveryPeriods" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:deliveryDate>
        </rtsrep:commodity>
        <rtsrep:deliveryQuantity>
          <fpml:totalPhysicalQuantity>
            <fpml:quantityUnit>{ get(source \\ "trade" \ "commodityForward" \ "commodityForwardPhysicalLeg" \ "deliveryQuantity" \\ "quantityUnit") }</fpml:quantityUnit>
            <fpml:quantity>{ get(source \\ "trade" \ "commodityForward" \ "commodityForwardPhysicalLeg" \ "deliveryQuantity" \\ "quantity") }</fpml:quantity>
          </fpml:totalPhysicalQuantity>
        </rtsrep:deliveryQuantity>
      </rtsrep:commodityPhysicalLeg>
      <rtsrep:floatingForwardLeg>
        { /* Uses dictionary from PartyTemplate for identifier */ }
        <fpml:payerPartyReference href={ parties(get(source \\ "trade" \ "commodityForward" \ "floatingForwardLeg" \ "payerPartyReference", "href").mkString)._1 }/>
        <fpml:receiverPartyReference href={ parties(get(source \\ "trade" \ "commodityForward" \ "floatingForwardLeg" \ "receiverPartyReference", "href").mkString)._1 }/>
        <rtsrep:commodity id={ get(source \\ "trade" \ "commodityForward" \ "floatingForwardLeg" \ "commodity", "id") }>
          <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "commodityForward" \ "floatingForwardLeg" \ "commodity" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "commodityForward" \ "floatingForwardLeg" \ "commodity" \ "instrumentId") }</fpml:instrumentId>
          <fpml:unit>{ get(source \\ "trade" \ "commodityForward" \ "floatingForwardLeg" \ "commodity" \ "unit") }</fpml:unit>
          <fpml:currency>{ get(source \\ "trade" \ "commodityForward" \ "floatingForwardLeg" \ "commodity" \ "currency") }</fpml:currency>
        </rtsrep:commodity>
        <fpml:totalNotionalQuantity>{ get(source \\ "trade" \ "commodityForward" \ "floatingForwardLeg" \ "totalNotionalQuantity") }</fpml:totalNotionalQuantity>
        { /* Should be filled. calculation/pricingDates isn`t present in source!!!*/ }
        <rtsrep:calculation>
          <fpml:pricingDates>
            <fpml:pricingDates>
              <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityForward" \ "floatingForwardLeg" \ "paymentDates" \\ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:pricingDates>
          </fpml:pricingDates>
        </rtsrep:calculation>
        <fpml:paymentDates>
          <fpml:adjustableDates>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityForward" \ "floatingForwardLeg" \ "paymentDates" \\ "unadjustedDate") }</fpml:unadjustedDate>
          </fpml:adjustableDates>
        </fpml:paymentDates>
      </rtsrep:floatingForwardLeg>
    </fpml:commodityForward>
  }

  def isStraight = true
}
