package templates

import scala.xml.Node

class CommodityOptionTemplate(source: Node) extends TradeTemplate(source) {
  protected[this] def templateTradeBody: Node = {
    <fpml:commodityOption>
      { /* productType is unknown for RTS */ }
      { /*<fpml:productType>{ get(source \\ "trade" \ "commodityOption" \ "productType") }</fpml:productType> */ }
      <fpml:productId productIdScheme={ get(source \\ "trade" \ "commodityOption" \ "productId", "productIdScheme") }>{ get(source \\ "trade" \ "commodityOption" \ "productId") }</fpml:productId>
      { /* Uses dictionary from PartyTemplate for identifier */ }
      <fpml:buyerPartyReference href={ parties(get(source \\ "trade" \ "commodityOption" \ "buyerPartyReference", "href").mkString)._1 }/>
      <fpml:sellerPartyReference href={ parties(get(source \\ "trade" \ "commodityOption" \ "sellerPartyReference", "href").mkString)._1 }/>
      { /* Should be filled. optionType isn`t present in source!!!*/ }
      <fpml:optionType>{ get(source \\ "trade" \ "commodityOption" \ "optionType") }</fpml:optionType>
      {/* <fpml:optionType>{ if (get(source \\ "trade" \ "commodityOption" \ "buyerPartyReference", "href").mkString == "Party1") "Call" else "Put" }</fpml:optionType> */ }
      <fpml:commodity id={ get(source \\ "trade" \ "commodityOption" \ "commodity", "id") }>
        <fpml:instrumentId instrumentIdScheme={ get(source \\ "trade" \ "commodityOption" \ "commodity" \ "instrumentId", "instrumentIdScheme") }>{ get(source \\ "trade" \ "commodityOption" \ "commodity" \ "instrumentId") }</fpml:instrumentId>
        <fpml:unit>{ get(source \\ "trade" \ "commodityOption" \ "commodity" \ "unit") }</fpml:unit>
        <fpml:currency>{ get(source \\ "trade" \ "commodityOption" \ "commodity" \ "currency") }</fpml:currency>
      </fpml:commodity>
      { /* effectiveDate isn`t present in source!!!*/ }
      <fpml:effectiveDate>
        <fpml:adjustableDate>
          <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityOption" \ "exercise" \ "paymentDates" \\ "unadjustedDate" ) }</fpml:unadjustedDate>
        </fpml:adjustableDate>
      </fpml:effectiveDate>
      <fpml:totalNotionalQuantity>{ get(source \\ "trade" \ "commodityOption" \ "totalNotionalQuantity") }</fpml:totalNotionalQuantity>
      <fpml:exercise>
        <fpml:americanExercise>
          <fpml:exercisePeriod>
            <fpml:commencementDate>
              <fpml:adjustableDate>
                <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityOption" \\ "americanExercise" \\ "commencementDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
              </fpml:adjustableDate>
            </fpml:commencementDate>
            <fpml:expirationDate>
              <fpml:adjustableDate>
                <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityOption" \\ "americanExercise" \\ "expirationDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
              </fpml:adjustableDate>
            </fpml:expirationDate>
          </fpml:exercisePeriod>
        </fpml:americanExercise>
        <fpml:europeanExercise>
          <fpml:expirationDate>
            <fpml:adjustableDate>
              <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityOption" \\ "europeanExercise" \\ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:adjustableDate>
          </fpml:expirationDate>
        </fpml:europeanExercise>
        <fpml:settlementCurrency>{ get(source \\ "trade" \ "commodityOption" \ "exercise" \ "settlementCurrency") }</fpml:settlementCurrency>
        <fpml:paymentDates>
          <fpml:adjustableDates>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityOption" \ "exercise" \ "paymentDates" \\ "unadjustedDate" ) }</fpml:unadjustedDate>
          </fpml:adjustableDates>
        </fpml:paymentDates>
      </fpml:exercise>
      <fpml:strikePricePerUnit>
        <fpml:currency>{ get(source \\ "trade" \ "commodityOption" \ "strikePricePerUnit" \ "currency") }</fpml:currency>
        <fpml:amount>{ get(source \\ "trade" \ "commodityOption" \ "strikePricePerUnit" \ "amount") }</fpml:amount>
      </fpml:strikePricePerUnit>
      <fpml:floatingStrikePricePerUnit>
        <fpml:pricingDates>
          <fpml:pricingDates>
            <fpml:unadjustedDate>{ get(source \\ "trade" \ "commodityOption" \ "floatingStrikePricePerUnit" \ "pricingDates" \\ "unadjustedDate" ) }</fpml:unadjustedDate>
          </fpml:pricingDates>
        </fpml:pricingDates>
        <fpml:spread>
          <fpml:currency>{ get(source \\ "trade" \ "commodityOption" \ "floatingStrikePricePerUnit" \\ "currency") }</fpml:currency>
          <fpml:amount>{ get(source \\ "trade" \ "commodityOption" \ "floatingStrikePricePerUnit" \\ "amount") }</fpml:amount>
          <fpml:spreadUnit>{ get(source \\ "trade" \ "commodityOption" \ "floatingStrikePricePerUnit" \\ "spreadUnit") }</fpml:spreadUnit>
        </fpml:spread>
        <fpml:spreadPercentage>{ get(source \\ "trade" \ "commodityOption" \ "floatingStrikePricePerUnit" \ "spreadPercentage") }</fpml:spreadPercentage>
      </fpml:floatingStrikePricePerUnit>
      <fpml:premium>
        { /* Uses dictionary from PartyTemplate for identifier */ }
        <fpml:payerPartyReference href={ parties(get(source \\ "trade" \ "commodityOption" \ "premium" \"payerPartyReference", "href").mkString)._1 }/>
        <fpml:receiverPartyReference href={ parties(get(source \\ "trade" \ "commodityOption" \ "premium" \"receiverPartyReference", "href").mkString)._1 }/>
        <fpml:paymentAmount>
          <fpml:currency>{ get(source \\ "trade" \ "commodityOption" \ "premium" \\ "currency") }</fpml:currency>
          <fpml:amount>{ get(source \\ "trade" \ "commodityOption" \ "premium" \\ "amount") }</fpml:amount>
        </fpml:paymentAmount>
      </fpml:premium>
    </fpml:commodityOption>
  }

  def isStraight = true
}
