package templates

import scala.xml.Node

class CommoditySwapTemplate(source: Node) extends TradeTemplate(source) {
  protected[this] def templateTradeBody: Node = {
    <fpml:commoditySwap>
      { /* productType is unknown for RTS */ }
      { /* <fpml:productType>{ get(source \\ "trade" \ "commoditySwap" \ "productType") }</fpml:productType> */}
      <fpml:productId>{ get(source \\ "trade" \ "commoditySwap" \ "productId") }</fpml:productId>
      <fpml:effectiveDate>
        <fpml:adjustableDate>
          <fpml:unadjustedDate>{ get(source \\ "trade" \ "commoditySwap" \ "effectiveDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
        </fpml:adjustableDate>
      </fpml:effectiveDate>
      <fpml:terminationDate>
        <fpml:adjustableDate>
          <fpml:unadjustedDate>{ get(source \\ "trade" \ "commoditySwap" \ "terminationDate" \\ "unadjustedDate") }</fpml:unadjustedDate>
        </fpml:adjustableDate>
      </fpml:terminationDate>
      <fpml:settlementCurrency>{ get(source \\ "trade" \ "commoditySwap" \ "settlementCurrency") }</fpml:settlementCurrency>
      { for (s <- source \\ "trade" \ "commoditySwap" \ "fixedLeg") yield {
          <fpml:fixedLeg>
            { /* Uses dictionary from PartyTemplate for identifier */ }
            <fpml:payerPartyReference href={ parties(get(s \ "payerPartyReference", "href").mkString)._1 }/>
            <fpml:receiverPartyReference href={ parties(get(s \ "receiverPartyReference", "href").mkString)._1 }/>
            <fpml:calculationDates>
              <fpml:unadjustedDate>{ get(s \ "calculationDates" \ "unadjustedDate") }</fpml:unadjustedDate>
            </fpml:calculationDates>
            <fpml:fixedPrice>
              <fpml:price>{ get(s \ "fixedPrice" \ "price") }</fpml:price>
              <fpml:priceCurrency>{ get(s \ "fixedPrice" \ "priceCurrency") }</fpml:priceCurrency>
              <fpml:priceUnit>{ get(s \ "fixedPrice" \ "priceUnit") }</fpml:priceUnit>
            </fpml:fixedPrice>
            <fpml:totalPrice>
              <fpml:currency>{ get(s \ "totalPrice" \ "currency") }</fpml:currency>
              <fpml:amount>{ get(s \ "totalPrice" \ "amount") }</fpml:amount>
            </fpml:totalPrice>
            <fpml:totalNotionalQuantity>{ get(s \ "totalNotionalQuantity") }</fpml:totalNotionalQuantity>
            <fpml:paymentDates>
              <fpml:adjustableDates>
                <fpml:unadjustedDate>{ get(s \ "paymentDates" \\ "unadjustedDate") }
                </fpml:unadjustedDate>
              </fpml:adjustableDates>
            </fpml:paymentDates>
          </fpml:fixedLeg>
        }
    }
    </fpml:commoditySwap>
  }

  def isStraight = true
}
