package templates

import scala.xml.Node

class FairValueReportTemplate(source: Node) extends PartyTemplate(source) {

  def template: Node = {
    <rtsrep:fairValueReportRegistration xmlns:fpml="http://www.fpml.org/FpML-5/recordkeeping"
                                   xmlns:fpmlext="http://www.fpml.org/FpML-5/ext" xmlns:rtsrep="http://www.fpml.ru/repository"
                                   xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" fpmlVersion="5-7">
      <fpml:header>
        <fpml:messageId>{ get(source \ "header" \"messageId") }</fpml:messageId>
        <fpml:sentBy>{ get(source \ "header" \ "sentBy") }</fpml:sentBy>
        <fpml:sendTo>{ get(source \ "header" \ "sendTo") }</fpml:sendTo>
        <fpml:creationTimestamp>{ get(source \ "header" \ "creationTimestamp") }</fpml:creationTimestamp>
        <fpml:implementationSpecification>
          <fpml:version>2</fpml:version>
        </fpml:implementationSpecification>
      </fpml:header>
      <fpml:isCorrection>{ get(source \ "isCorrection") }</fpml:isCorrection>
      <fpml:correlationId correlationIdScheme="">{ get(source \ "correlationId") }</fpml:correlationId>
      <rtsrep:fairValueReport>
        <rtsrep:fairValueReportId>{ get(source \ "markToMarketValuation" \ "MTMIdentifier") }</rtsrep:fairValueReportId>
        <rtsrep:tradeId>{ get(source \ "markToMarketValuation" \ "markToMarketDetails" \ "markToMarketInformation" \ "tradeId") }</rtsrep:tradeId>
        <rtsrep:valuationTechnique>{ get(source \ "markToMarketValuation" \ "valuationMethod") }</rtsrep:valuationTechnique>
        <rtsrep:fairValue>
          <fpml:currency>{ get(source \ "markToMarketValuation" \ "markToMarketDetails" \ "markToMarketInformation" \ "currency") }</fpml:currency>
          <fpml:amount>{ get(source \ "markToMarketValuation" \ "markToMarketDetails" \ "markToMarketInformation" \ "amount") }</fpml:amount>
        </rtsrep:fairValue>
        <rtsrep:valuationDate>{ get(source \ "markToMarketValuation" \ "markToMarketDetails" \ "valuationDateTime") }</rtsrep:valuationDate>
      </rtsrep:fairValueReport>
      { /* Uses dictionary from PartyTemplate for identifier */ }
      { for { s <- source \ "party"
              id = get(s, "id").mkString
              if id != "Sender" && id != "UTIGeneratingParty" } yield {
          <fpml:party id={ parties(id)._1 }>
            <fpml:partyId partyIdScheme={ parties(id)._2 }>{ parties(id)._1 }</fpml:partyId>
            <fpml:partyName>{ get(s \ "partyName") }</fpml:partyName>
            <fpml:country>{ get(s \ "country") }</fpml:country>
            <fpml:organizationType>{ get(s \ "classification") }</fpml:organizationType>
          </fpml:party>
        }
      }
    </rtsrep:fairValueReportRegistration>
  }

  def isStraight = true
}
