package templates

import scala.xml.Node

abstract class PartyTemplate(source: Node) extends Template(source) {
  var c = 0
  protected[this] val parties = {
    val p1 =
      for { s <- source \ "party"
            id = get(s, "id").mkString
            if id != "Sender" && id != "UTIGeneratingParty"} yield {
        val partyId0 = get(s \ "partyId").mkString.filterNot(_.isWhitespace)

        if (partyId0 != "NONREF")
          id -> (partyId0, msgNotFound)
        else {
          val partyId1 = get(s \ "partyId", null, 1).mkString.filterNot(_.isWhitespace).replace("INN", "ITN")

          id -> (partyId1, partyId1.split('_').head)
        }
      }

    val p2 =
      for { s <- source \\ "trade" \ "nsdSpecificTradeFields" \ "clientDetails"
            id = get(s \ "id").mkString
            if id != msgNotFound } yield {
        val partyId = id.filterNot(_.isWhitespace).replace("INN", "ITN")

        id -> (partyId, partyId.split('_').head)
      }

    (p1 ++ p2).toMap.withDefaultValue((msgNotFound, msgNotFound))
  }
}
